# Quick Setup Guide

## Step 1: Database Setup

1. **Create Database**
   - Access phpMyAdmin or MySQL command line
   - Import `database.sql` file
   - This creates:
     - Database: `employee_attendance`
     - Tables: `admins`, `employees`, `attendance`
     - Default admin account

2. **Default Admin Credentials**
   - Email: `admin@example.com`
   - Password: `admin123`
   - **⚠️ CHANGE THIS IMMEDIATELY AFTER FIRST LOGIN!**

## Step 2: Configure Database Connection

Edit `config/db.php`:

```php
define('DB_HOST', 'localhost');        // Your MySQL host
define('DB_NAME', 'employee_attendance'); // Database name
define('DB_USER', 'your_username');     // Your MySQL username
define('DB_PASS', 'your_password');     // Your MySQL password
```

## Step 3: Update Base URL (Important!)

Edit `admin/dashboard.php` around line 12:

```php
// Option 1: Auto-detect (works for most cases)
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];

// Option 2: Manual (recommended for production)
$baseUrl = "https://yourdomain.com";
```

## Step 4: Upload Files

Upload all files to your web server:
- For cPanel: Upload to `public_html` folder
- Ensure `.htaccess` is uploaded
- Check file permissions (644 for files, 755 for folders)

## Step 5: Test

1. Visit: `https://yourdomain.com/admin/login.php`
2. Login with default credentials
3. Create a test employee
4. Download QR code and test attendance

## Changing Admin Password

### Method 1: Using PHP Script

Create `change_password.php` (temporary file):

```php
<?php
require_once 'config/db.php';

$newPassword = 'your_new_secure_password';
$email = 'admin@example.com';

$hash = password_hash($newPassword, PASSWORD_DEFAULT);

$pdo = getDB();
$stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE email = ?");
$stmt->execute([$hash, $email]);

echo "Password updated!";
```

Run it once, then **DELETE** the file.

### Method 2: Direct SQL

```sql
UPDATE admins 
SET password_hash = '$2y$10$YOUR_NEW_HASH_HERE' 
WHERE email = 'admin@example.com';
```

Generate hash using:
```php
<?php echo password_hash('your_password', PASSWORD_DEFAULT); ?>
```

## Troubleshooting

### "Database connection failed"
- Check `config/db.php` credentials
- Verify database exists
- Check MySQL user permissions

### "Invalid token" on attendance page
- Verify base URL in `dashboard.php`
- Check QR code contains correct URL
- Ensure token exists in database

### QR codes not displaying
- Check internet connection (uses external service)
- Verify base URL is correct
- Check browser console for errors

### CSS/JS not loading
- Verify paths start with `/` (absolute paths)
- Check `.htaccess` is working
- Clear browser cache

## Security Checklist

- [ ] Changed default admin password
- [ ] Updated database credentials
- [ ] Set correct base URL
- [ ] Enabled HTTPS (if available)
- [ ] Deleted any temporary setup files
- [ ] Set proper file permissions
- [ ] Backed up database

## File Permissions

```bash
# Files
chmod 644 *.php
chmod 644 *.css
chmod 644 .htaccess

# Directories
chmod 755 config/
chmod 755 admin/
chmod 755 api/
chmod 755 css/
chmod 755 assets/
```

## Next Steps

1. Create your first employee
2. Test QR code scanning
3. Test check-in/check-out functionality
4. Customize styling if needed
5. Set up regular database backups
